import java.util.Random;
import java.util.ArrayList;
import java.util.Arrays;

public class MarketGenerator {

    private Random rand;
    private TradeGenerator[] generators;

    public MarketGenerator (int n, double seed) {
        generators = new TradeGenerator[n];
        rand = new Random();
        for (int i = 0; i < n; i++) generators[i] = new TradeGenerator(rand.nextDouble() * seed);
    }

    public Object[][][] simulate (int min, int max) {
        int count;
        Object[][][] history;
        ArrayList<Object[]> trades = new ArrayList<Object[]>();
        ArrayList<Object[]> quotes = new ArrayList<Object[]>();
        TradeGenerator generator;
        for (int i = 0; i < generators.length; i++) {
            generator = generators[i];
            count = min + rand.nextInt(max - min);
            history = generator.simulate(count);
            quotes.addAll(Arrays.asList(history[0]));
            trades.addAll(Arrays.asList(history[1]));
        }
        return new Object[][][]{
            quotes.toArray(new Object[quotes.size()][6]),
            trades.toArray(new Object[trades.size()][4])
        };
    }


    public static void main (final String[] args) {
        MarketGenerator generator = new MarketGenerator(10, 10000);
        Object[][][] history = generator.simulate(1, 10);
        Object[][]   quotes  = history[0];
        Object[][]   trades  = history[1];

        System.out.println("== trades ==");
        for (int i = 0; i < trades.length; i++) System.out.println(Arrays.toString(trades[i]));
        System.out.println("== quotes ==");
        for (int i = 0; i < quotes.length; i++) System.out.println(Arrays.toString(quotes[i]));
    }
}
